/*
 * Decompiled with CFR 0.152.
 */
package net.voidz.mixin;

import com.mojang.authlib.GameProfile;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.voidz.access.ServerPlayerAccess;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerPlayer.class})
public abstract class ServerPlayerEntityMixin
extends Player
implements ServerPlayerAccess {
    @Unique
    private BlockPos voidPortingBlockPos = new BlockPos(0, 0, 0);

    public ServerPlayerEntityMixin(Level world, BlockPos pos, float yaw, GameProfile gameProfile) {
        super(world, pos, yaw, gameProfile);
    }

    @Inject(method={"readCustomDataFromNbt"}, at={@At(value="TAIL")})
    private void readCustomDataFromNbtMixin(CompoundTag nbt, CallbackInfo info) {
        if (nbt.m_128441_("VoidPortingBlockPosX")) {
            this.voidPortingBlockPos = new BlockPos(nbt.m_128451_("VoidPortingBlockPosX"), nbt.m_128451_("VoidPortingBlockPosY"), nbt.m_128451_("VoidPortingBlockPosZ"));
        } else if (this.m_9236_() != null && this.m_9236_() instanceof ServerLevel) {
            this.voidPortingBlockPos = ((ServerLevel)this.m_9236_()).m_220360_();
        }
    }

    @Inject(method={"writeCustomDataToNbt"}, at={@At(value="TAIL")})
    private void writeCustomDataToNbtMixin(CompoundTag nbt, CallbackInfo info) {
        nbt.m_128405_("VoidPortingBlockPosX", this.voidPortingBlockPos.m_123341_());
        nbt.m_128405_("VoidPortingBlockPosY", this.voidPortingBlockPos.m_123342_());
        nbt.m_128405_("VoidPortingBlockPosZ", this.voidPortingBlockPos.m_123343_());
    }

    @Override
    public void setVoidPortingBlockPos(BlockPos pos) {
        this.voidPortingBlockPos = pos;
    }

    @Override
    public BlockPos getVoidPortingBlockPos() {
        return this.voidPortingBlockPos;
    }
}

